package com.cxdn.samples.swair.reservation;

import com.cxdn.samples.swair.*;

import java.util.Random;

/*
* La classe <code>Reservation</code> gre les informations 
* d'une rservation prise en charge par le systme de rservation 
* de la centrale de rservation.
*
* @version  1.0
*/
public class Reservation {
	
	private final static Random idGenerator = new Random();

	private int id = 0;

	private int passengers = 0;
	private String from = "";
	private String to = "";
	private boolean roundTrip = false;
	private int departureDay = 0;
	private int departureMonth = 0;
	private int departureYear = 0;
	private int arrivalDay = 0;
	private int arrivalMonth = 0;
	private int arrivalYear = 0;

	private int remoteId = 0;
	private int departureAvailabilityId = 0; 
	private int arrivalAvailabilityId = 0;

	private AirAvailability[] airAvailabilities;
	
	/*
	* Le constructeur de rservation.
	*/
	public Reservation() {
		getId();
	}

	/*
	* Renvoie l'identifiant de la rservation.
	*/
	public int getId() {
		if (id != 0) {
			return id;
		}
		synchronized(idGenerator) {
			id = idGenerator.nextInt();
		}
		return id;
	}

	/*
	* Renvoie l'identifiant de la rservation
	* du partenaire de rservation.
	*/
	public int getRemoteId() {
		return remoteId;
	}

	/*
	* Affecte l'identifiant de la rservation
	* du partenaire de rservation.
	*
	* @param		remoteId l'identifiant de la rservation
	*				du partenaire de rservation
	*/
	public void setRemoteId(int remoteId) {
		this.remoteId = remoteId;
	}

	/*
	* Renvoie l'identifiant de la disponibilit
	* de dpart rserve.
	*
	* @return		int l'identifiant de la disponibilit
	*/
	public int getDepartureAvailabilityId() {
		return this.departureAvailabilityId;
	}

	/*
	* Affecte l'identifiant de la disponibilit
	* de dpart rserve.
	*
	* @param		id l'identifiant de la disponibilit
	*/
	public void setDepartureAvailabilityId(int id) {
		this.departureAvailabilityId = id;
	}

	/*
	* Renvoie l'identifiant de la disponibilit
	* d'arrive rserve.
	*
	* @return		int l'identifiant de la disponibilit
	*/
	public int getArrivalAvailabilityId() {
		return this.arrivalAvailabilityId;
	}

	/*
	* Affecte l'identifiant de la disponibilit
	* d'arrive rserve.
	*
	* @param		id l'identifiant de la disponibilit
	*/
	public void setArrivalAvailabilityId(int id) {
		this.arrivalAvailabilityId = id;
	}

	/*
	* Affiche dans la log du serveur le statut de la
	* rservation effectue par l'utilisateur.
	*
	* @param		departureAvailabilityId l'identifiant
	*				de la disponibilit (vol aller) si la
	*				rservation a t confirme; 0 sinon
	* @param		arrivalAvailabilityId l'identifiant
	*				de la disponibilit (vol retour) si la
	*				rservation a t confirme; 0 sinon
	*/
	public void status(int departureAvailabilityId, int arrivalAvailabilityId)
		throws ReservationException {

		StringBuffer sb = new StringBuffer();
		sb.append("\nrservation ");
		if (departureAvailabilityId!=0) {
			sb.append("confirme");
		}
		else {
			sb.append("annule");
		}
		sb.append(" par SW-Air");
		sb.append("\n localit de dpart : ");
		sb.append(getFrom());
		sb.append("\n localit d'arrive : ");
		sb.append(getTo());
		sb.append("\n date de dpart : ");
		sb.append(getDepartureDay());
		sb.append("-");
		sb.append(getDepartureMonth());
		sb.append("-");
		sb.append(getDepartureYear());
		sb.append("\n voyage : ");
		if (getRoundTrip()) {
			sb.append("aller retour");
			sb.append("\n date de retour : ");
			sb.append(getArrivalDay());
			sb.append("-");
			sb.append(getArrivalMonth());
			sb.append("-");
			sb.append(getArrivalYear());
		}
		else {
			sb.append("aller simple");
		}
		sb.append("\n voyageurs : ");
		sb.append(getPassengers());
		sb.append("\n");
		System.out.println(sb);
		
		if (departureAvailabilityId!=0) {
			AirAvailability availability = getAvailability(departureAvailabilityId);
			setDepartureAvailabilityId(departureAvailabilityId);
			status(availability);
			if (arrivalAvailabilityId!=0) {
				availability = getAvailability(arrivalAvailabilityId);
				setArrivalAvailabilityId(arrivalAvailabilityId);
				status(availability);
			}
		}
		else {
			setDepartureAvailabilityId(0);
			setArrivalAvailabilityId(0);
		}
	}

	/*
	* Affiche dans la log du serveur le statut de la
	* disponibilit associe  la rservation.
	*/
	public void status(AirAvailability availability) {

		StringBuffer sb = new StringBuffer();
		sb.append("\n compagnie arienne : ");
		sb.append(availability.getAirCompany());
		sb.append("\n n de vol : ");
		sb.append(availability.getFlightNumber());
		sb.append("\n aroport dpart : ");
		sb.append(availability.getDepartureAirport());
		sb.append("\n aroport arrive : ");
		sb.append(availability.getArrivalAirport());
		sb.append("\n heure dpart : ");
		sb.append(availability.getDepartureHour());
		sb.append("\n heure arrive : ");
		sb.append(availability.getArrivalHour());
		sb.append("\n prix : ");
		sb.append(availability.getPrice());
		sb.append("\n");
		System.out.println(sb);
	}

	/*
	* Renvoie la disponibilit de SW-Air dont l'identifiant 
	* est pass en paramtre.
	*/
	private AirAvailability getAvailability(int availabilityId)
		throws ReservationException {

		AirAvailability[] availabilities = getAirAvailabilities();
		for(int i=0; i<availabilities.length; i++) {
			AirAvailability availability = availabilities[i];
			if (availability.getId()==availabilityId) {
				return availabilities[i];
			}
		}
		throw new ReservationException("disponibilit non trouve");
	}

	/*
	* Renvoie les disponibilits de SW-Air associes  
	* cette rservation.
	*/
	public synchronized AirAvailability[] getAirAvailabilities() {
		if (airAvailabilities!=null) {
			return airAvailabilities;
		}

		if ((!from.equalsIgnoreCase("Paris-CDG")) || (!to.equalsIgnoreCase("Vienne"))) {
			return new AirAvailability[]{};
		}
		
		if (roundTrip) {
			airAvailabilities = new AirAvailability[6];
		}
		else {
			airAvailabilities = new AirAvailability[3];
		}
		AirAvailability airAvailability1 = new AirAvailability();
		int id = idGenerator.nextInt();
		airAvailability1.setId(id);
		airAvailability1.setRemoteId(id);
		airAvailability1.setAirCompany("SW Luft Austria");
		airAvailability1.setFlightNumber("LA2365");
		airAvailability1.setDepartureAirport("Paris-CDG");
		airAvailability1.setArrivalAirport("Vienne");
		airAvailability1.setDepartureHour("07h15");
		airAvailability1.setArrivalHour("09h15");
		airAvailability1.setDirection(true);
		airAvailability1.setPrice(1240*passengers);
		airAvailabilities[0] = airAvailability1;
		AirAvailability airAvailability2 = new AirAvailability();
		id = idGenerator.nextInt();
		airAvailability2.setId(id);
		airAvailability2.setRemoteId(id);
		airAvailability2.setAirCompany("SW Air Fleet");
		airAvailability2.setFlightNumber("AF1765");
		airAvailability2.setDepartureAirport("Paris-CDG");
		airAvailability2.setArrivalAirport("Vienne");
		airAvailability2.setDepartureHour("09h15");
		airAvailability2.setArrivalHour("11h40");
		airAvailability2.setDirection(true);
		airAvailability2.setPrice(1260*passengers);
		airAvailabilities[1] = airAvailability2;
		AirAvailability airAvailability3 = new AirAvailability();
		id = idGenerator.nextInt();
		airAvailability3.setId(id);
		airAvailability3.setRemoteId(id);
		airAvailability3.setAirCompany("SW Air Fleet");
		airAvailability3.setFlightNumber("AF2913");
		airAvailability3.setDepartureAirport("Paris-CDG");
		airAvailability3.setArrivalAirport("Vienne");
		airAvailability3.setDepartureHour("19h10");
		airAvailability3.setArrivalHour("21h15");
		airAvailability3.setDirection(true);
		airAvailability3.setPrice(1200*passengers);
		airAvailabilities[2] = airAvailability3;
		if (roundTrip) {
			AirAvailability airAvailability4 = new AirAvailability();
			id = idGenerator.nextInt();
			airAvailability4.setId(id);
			airAvailability4.setRemoteId(id);
			airAvailability4.setAirCompany("SW Air Fleet");
			airAvailability4.setFlightNumber("AF1854");
			airAvailability4.setDepartureAirport("Vienne");
			airAvailability4.setArrivalAirport("Paris-CDG");
			airAvailability4.setDepartureHour("12h35");
			airAvailability4.setArrivalHour("14h40");
			airAvailability4.setDirection(false);
			airAvailability4.setPrice(1240*passengers);
			airAvailabilities[3] = airAvailability4;
			AirAvailability airAvailability5 = new AirAvailability();
			id = idGenerator.nextInt();
			airAvailability5.setId(id);
			airAvailability5.setRemoteId(id);
			airAvailability5.setAirCompany("SW Air Fleet");
			airAvailability5.setFlightNumber("AF2317");
			airAvailability5.setDepartureAirport("Vienne");
			airAvailability5.setArrivalAirport("Paris-CDG");
			airAvailability5.setDepartureHour("15h30");
			airAvailability5.setArrivalHour("17h35");
			airAvailability5.setDirection(false);
			airAvailability5.setPrice(1260*passengers);
			airAvailabilities[4] = airAvailability5;
			AirAvailability airAvailability6 = new AirAvailability();
			id = idGenerator.nextInt();
			airAvailability6.setId(id);
			airAvailability6.setRemoteId(id);
			airAvailability6.setAirCompany("SW Luft Austria");
			airAvailability6.setFlightNumber("LA3421");
			airAvailability6.setDepartureAirport("Vienne");
			airAvailability6.setArrivalAirport("Paris-CDG");
			airAvailability6.setDepartureHour("19h40");
			airAvailability6.setArrivalHour("21h45");
			airAvailability6.setDirection(false);
			airAvailability6.setPrice(1200*passengers);
			airAvailabilities[5] = airAvailability6;
		}
		return airAvailabilities;
	}

	/*
	* Affecte les disponibilits de SW-Air associes 
	* cette rservation.
	*
	* @param		airAvailabilities les disponibilits
	*				de SW-Air
	*/
	public void setAirAvailabilities(AirAvailability[] airAvailabilities) {
		this.airAvailabilities = airAvailabilities;
	}

	/*
	* Renvoie le nombre de voyageurs.
	*
	* @return		int le nombre de voyageurs
	*/
	public int getPassengers() {
		return this.passengers;
	}

	/*
	* Affecte le nombre de voyageurs.
	*
	* @param		passengers le nombre de voyageurs
	*/
	public void setPassengers(int passengers) {
		this.passengers = passengers;
	}

	/*
	* Renvoie la localit de dpart.
	*
	* @return		String la localit de dpart
	*/
	public String getFrom() {
		return this.from;
	}

	/*
	* Affecte la localit de dpart.
	*
	* @param		from la localit de dpart
	*/
	public void setFrom(String from) {
		this.from = from;
	}

	/*
	* Renvoie la localit d'arrive.
	*
	* @return		String la localit d'arrive
	*/
	public String getTo() {
		return this.to;
	}

	/*
	* Affecte la localit d'arrive.
	*
	* @param		from la localit d'arrive
	*/
	public void setTo(String to) {
		this.to = to;
	}

	/*
	* Renvoie le voyage.
	*
	* @return		boolean le voyage
	*/
	public boolean getRoundTrip() {
		return this.roundTrip;
	}

	/*
	* Affecte le voyage.
	*
	* @param		roundTrip le voyage
	*/
	public void setRoundTrip(boolean roundTrip) {
		this.roundTrip = roundTrip;
	}

	/*
	* Renvoie le jour de dpart.
	*
	* @return		int le jour de dpart
	*/
	public int getDepartureDay() {
		return this.departureDay;
	}

	/*
	* Affecte le jour de dpart.
	*
	* @param		departureDay le jour de dpart
	*/
	public void setDepartureDay(int departureDay) {
		this.departureDay = departureDay;
	}

	/*
	* Renvoie le mois de dpart.
	*
	* @return		int le mois de dpart
	*/
	public int getDepartureMonth() {
		return this.departureMonth;
	}

	/*
	* Affecte le mois de dpart.
	*
	* @param		departureMonth le mois de dpart
	*/
	public void setDepartureMonth(int departureMonth) {
		this.departureMonth = departureMonth;
	}

	/*
	* Renvoie l'anne de dpart.
	*
	* @return		int l'anne de dpart
	*/
	public int getDepartureYear() {
		return this.departureYear;
	}

	/*
	* Affecte l'anne de dpart.
	*
	* @param		departureYear l'anne de dpart
	*/
	public void setDepartureYear(int departureYear) {
		this.departureYear = departureYear;
	}

	/*
	* Renvoie le jour de retour.
	*
	* @return		int le jour de retour
	*/
	public int getArrivalDay() {
		return this.arrivalDay;
	}

	/*
	* Affecte le jour de retour.
	*
	* @param		arrivalDay le jour de retour
	*/
	public void setArrivalDay(int arrivalDay) {
		this.arrivalDay = arrivalDay;
	}

	/*
	* Renvoie le mois de retour.
	*
	* @return		int le mois de retour
	*/
	public int getArrivalMonth() {
		return this.arrivalMonth;
	}

	/*
	* Affecte le mois de retour.
	*
	* @param		arrivalMonth le mois de retour
	*/
	public void setArrivalMonth(int arrivalMonth) {
		this.arrivalMonth = arrivalMonth;
	}

	/*
	* Renvoie l'anne de retour.
	*
	* @return		int l'anne de retour
	*/
	public int getArrivalYear() {
		return this.arrivalYear;
	}

	/*
	* Affecte l'anne de retour.
	*
	* @param		arrivalYear l'anne de retour
	*/
	public void setArrivalYear(int arrivalYear) {
		this.arrivalYear = arrivalYear;
	}

	/*
	* Renvoie une reprsentation textuelle de la
	* rservation. 
	*
	* @return		une reprsentation textuelle de la
	* 				rservation.
	*/
	public String toString() {
		StringBuffer sb = new StringBuffer();
		sb.append("\n");
		sb.append(getClass().getName());
		sb.append("@");
		sb.append(Integer.toHexString(hashCode()));
		return sb.toString();
	}
}